const express = require("express");
const router = express.Router();
const subscriberController = require("../controllers/subscriberController");
const authController = require("../controllers/authController"); // Assuming you have this

// --- Public Routes ---
router.post("/", subscriberController.subscribe);

// --- Admin Protected Routes ---
// Apply protection to GET and DELETE so strangers can't see/delete your list
router.use(authController.protect);
router.use(authController.restrictTo("admin", "super-admin"));

router.get("/", subscriberController.getAllSubscribers);
router.delete("/:id", subscriberController.deleteSubscriber);

module.exports = router;
